library(readxl)
library(ggplot2)

# figure 1

figure1 <- read_excel("./figure1.xlsx")

figure1$item <- as.character(figure1$item)

figure1<-ggplot(figure1, aes(x=unit,y=cor_reprod, alpha=item))+
  theme(legend.text=element_text(size=10))+
  theme(legend.title=element_text(size=10))+
  geom_col(position="dodge", color="black", size=0.1)+
  expand_limits(y=0)+
  scale_x_continuous("minutes between repetitions", labels = as.character(figure1$time), breaks=figure1$unit)+
  theme(axis.title.y=element_text(size=10))+
  scale_y_continuous("% correct reproduction", limits=c(0,95), breaks=seq(0,95,by=5))+
  theme(axis.title.x=element_text(size=10))+
  theme(axis.text.x = element_text(size=10),
        axis.text.y = element_text(size=10))

figure1

# figure 2

figure2 <- read_excel("./figure2.xlsx")

figure2<-ggplot(figure2, aes(time,cor_reprod, group=1))+
  geom_col(size=2, colors="black")+
  ylab("% correct reproduction")+
  theme(axis.title.y=element_text(size=10))+
  xlab("minutes between repetitions")+
  theme(axis.title.x=element_text(size=10))+
  scale_y_continuous(limits=c(0,95), breaks=seq(0,95,by=5))+
  theme(axis.text.x = element_text(size=10, angle=90),
        axis.text.y = element_text(size=10))

figure2

